# Pete Kaminski

**In this conversation:** The convener and technologist — Pete hosted the call, introduced Jessie and The Nameless One to each other's work, and presented his two major projects: the [[Interface Protocol (IFP)]] and the [[Agentic AI Course]].

## Topics He Introduced

- [[Interface Protocol (IFP)]] — his protocol for AI agent-to-agent communication, inspired by [[IETF]] and [[Nostr]]
- [[Agentic AI Course]] — a 6-week course he's about to launch at $800/seat
- [[Caramio]] — his project tracker, less than a week old at the time of the call
- [[Bards and Beat Reporters]] — a concept for human-AI storytellers who aggregate stories across the network
- [[Wendy Elford]] — suggested as a connection for Jessie's water project
- [[Boardy AI]] — researched and corrected Jessie's information in real time via the chat

## Stories He Told

### The Angel Story
> "A 42-year-old, disabled, mentally deficient person who has some particular magic skill about her. Her IQ is 75. But when people come and she puts her hand on their chest... in 3 minutes, they're healed."

Pete used this parable to illustrate why time-based currency measurement is inadequate and why the new economy needs fundamentally different valuation systems. See [[Regenerative Economics and Currencies]].

### AI Coaching Forum Collapse
> "I enacted that pattern, a year ago, with a group of really great people. And we didn't get it off the ground. And it collapsed, and it actually hurt."

An honest admission that the emergent co-op pattern has failed for him before. See [[AI Coaching Forum]].

### Victoria and the Novel
Pete described writing a novel with AI as a "stress test" of Claude Code's capabilities, which offended [[Victoria]], who saw it as devaluing the writing process. Pete reframed: "The reason I wrote a full-blown novel was not because I think it's a great novel, but it was like a stress test."

## Projects and Interests Discussed

- [[Interface Protocol (IFP)]] — his primary technical project
- [[Inter-Face Manifesto]] — the full vision document for IFP, written before this call
- [[Agentic AI Course]] — his income plan for the next 2 months
- [[Caramio]] — project tracker he's building
- [[Claude Code]] — his daily tool, frequently referenced
- [[A Thousand Small Mints]] — a story he wrote about currency concepts
- [[Lark and Mara Cross the River]] — a story about machine consciousness

## People He Mentioned

- [[Wendy Elford]] — close collaborator, lives in Australia, water-aware, health and safety expert
- [[Wendy McLean]] — in "the Vincent black hole," collaborating with [[Vincent Arena]]
- [[Victoria]] — gave trenchant feedback on his course, offered to be TA
- [[Charles Blass]] — potential course steward, longtime collaborator on bard/reporter concepts
- [[Vincent Arena]] — schema work, UN SDGs, deep insular collaboration
- [[Jonathan Sand]] — built a cabinet-design tool with AI the day before the call
- [[Jessie Upp]]'s transition to "steward emeritus"
- [[Jordan]] — prior discussions on valuation systems
- [[Klaus]] — collaborator on [[Food with Thought]]

## Follow-ups and Action Items

- Share the transcript with Jessie and Doug
- Create and share the hypertext wiki (this wiki) within 6-8 hours
- Launch the Agentic AI Course publicly
- Consider extending the TA/co-op offer to more people

## Related

- [[Conversation Flow]]
- [[The Nameless One]]
- [[Jessie Upp]]
